/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.HThreadGroup;
import com.ibm.hwmca.fw.util.TimeExpiredException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkRequest;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class WorkThread
extends Thread {
    private static final String TRACE_MASKT = "XFRMWKTT";
    private static final String TRACE_MASKF = "XFRMWKTF";
    private String _name;
    private volatile boolean _runOnce;
    private volatile Thread _stopThread;
    private volatile boolean _threadSuspended;
    private volatile LinkedList requestQueue = new LinkedList();
    private volatile Object requestQueueLock = new Object();

    public static Throwable[] runSynchronously(Runnable[] targets, boolean daemon) {
        try {
            return WorkThread.runSynchronously(targets, daemon, 0L);
        }
        catch (TimeExpiredException e) {
            throw new RuntimeException("Probable coding error, this exception should never be thrown", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable[] runSynchronously(Runnable[] targets, boolean daemon, long timeout) throws TimeExpiredException {
        Trace.trace(TRACE_MASKT, "-> runSynchronously()");
        if (targets == null || targets.length == 0) {
            throw new IllegalArgumentException("'targets' parameter must be non null and non empty");
        }
        class RsWorker
        extends Thread {
            int position;
            Runnable target;
            private final /* synthetic */ Object val$isLock;
            private final /* synthetic */ Throwable[] val$returns;
            private final /* synthetic */ List val$workers;

            RsWorker(int position, Runnable target, Object val$isLock, Throwable[] val$returns, List val$workers) {
                super("WorkThread.runSynchronously() worker thread");
                this.val$isLock = val$isLock;
                this.val$returns = val$returns;
                this.val$workers = val$workers;
                this.position = position;
                this.target = target;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Object object;
                try {
                    try {
                        this.target.run();
                        Trace.trace(WorkThread.TRACE_MASKT, "runSynchronously() worker thread ending cleanly.");
                    }
                    catch (Error e) {
                        Object object2 = this.val$isLock;
                        synchronized (object2) {
                            this.val$returns[this.position] = e;
                        }
                        Trace.trace(WorkThread.TRACE_MASKT, "runSynchronously() worker ending due to java.lang.Error, reporting to caller.");
                        throw e;
                    }
                    catch (RuntimeException e) {
                        Object object3 = this.val$isLock;
                        synchronized (object3) {
                            this.val$returns[this.position] = e;
                        }
                        Trace.trace(WorkThread.TRACE_MASKT, "runSynchronously() worker ending due to java.lang.RuntimeException, reporting to caller.");
                        throw e;
                    }
                    Object var6_1 = null;
                    object = this.val$isLock;
                }
                catch (Throwable throwable) {
                    Object var6_2 = null;
                    Object object2 = this.val$isLock;
                    synchronized (object2) {
                        this.val$workers.remove(this);
                        this.val$isLock.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (object) {
                    this.val$workers.remove(this);
                    this.val$isLock.notifyAll();
                    return;
                }
            }
        }
        ArrayList<RsWorker> workers = new ArrayList<RsWorker>();
        Object isLock = new Object();
        Throwable[] returns = new Throwable[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            RsWorker worker = new RsWorker(i, targets[i], isLock, returns, workers);
            worker.setDaemon(daemon);
            returns[i] = null;
            Object object = isLock;
            synchronized (object) {
                workers.add(worker);
            }
            worker.start();
        }
        if (timeout > 0L) {
            long waited = 0L;
            long started = System.currentTimeMillis();
            Object object = isLock;
            synchronized (object) {
                while (!workers.isEmpty() && waited < timeout) {
                    try {
                        isLock.wait(timeout - waited);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    waited = System.currentTimeMillis() - started;
                }
                if (!workers.isEmpty()) {
                    throw new TimeExpiredException("Time expired before all threads completed", returns);
                }
            }
        }
        Object object = isLock;
        synchronized (object) {
            while (!workers.isEmpty()) {
                try {
                    isLock.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        Trace.trace(TRACE_MASKT, "<- runSynchronously()");
        return returns;
    }

    public static void invokeAsync(WorkListener listener, WorkPerformer performer, Object params, String threadName) {
        Trace.trace(TRACE_MASKT, "-> invokeAsync() for " + threadName);
        WorkThread worker = new WorkThread(threadName);
        worker.startWorkerOnce();
        worker.requestWork(listener, performer, null, params);
        Trace.trace(TRACE_MASKT, "<- invokeAsync");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Trace.trace(TRACE_MASKT, "-> WorkThread.run() for " + this._name);
        Thread thisThread = Thread.currentThread();
        while (this._stopThread == thisThread) {
            try {
                Trace.trace(TRACE_MASKF, "WorkThread is not stopped.");
                WorkThread workThread = this;
                synchronized (workThread) {
                    while ((this._threadSuspended || this.requestQueue.isEmpty()) && this._stopThread == thisThread) {
                        Trace.trace(TRACE_MASKF, "WorkThread is not stopped and suspended or no work.  About to wait()");
                        this.wait();
                    }
                }
                if (this._stopThread != thisThread) continue;
                while (!this.requestQueue.isEmpty()) {
                    Trace.trace(TRACE_MASKF, "There is work on the queue.");
                    WorkRequest request = null;
                    Object object = this.requestQueueLock;
                    synchronized (object) {
                        request = (WorkRequest)this.requestQueue.removeFirst();
                    }
                    Trace.trace(TRACE_MASKF, "Processing work request " + request.getRequestId() + ".");
                    Object params = request.getParameters();
                    WorkPerformer performer = request.getPerformer();
                    Throwable requestEx = null;
                    Object retValue = null;
                    try {
                        retValue = performer.performWork(params);
                    }
                    catch (Throwable e) {
                        Trace.trace(TRACE_MASKF, "WorkPerformer for work request " + request.getRequestId() + "threw exception: " + e);
                        Trace.trace(TRACE_MASKF, e);
                        requestEx = e;
                    }
                    Trace.trace(TRACE_MASKF, "WorkPerformer completed for work request " + request.getRequestId() + ".");
                    WorkEvent event = new WorkEvent(performer, request.getRequestId(), requestEx, retValue);
                    request.getListener().workCompleted(event);
                    if (!this._runOnce) continue;
                    this._stopThread = null;
                    Object object2 = this.requestQueueLock;
                    synchronized (object2) {
                        this.requestQueue.clear();
                    }
                }
                Trace.trace(TRACE_MASKF, "Work queue is empty");
            }
            catch (InterruptedException e) {
                Trace.trace(TRACE_MASKF, "WorkThread was interrupted.  Looping around again...");
            }
        }
        Trace.trace(TRACE_MASKT, "-> WorkThread.run()");
    }

    public WorkThread(String name) {
        super((ThreadGroup)HThreadGroup.defaultThreadGroup(), name + " (WorkThread)");
        this._name = name + " (WorkThread)";
        this._stopThread = this;
        this._threadSuspended = false;
        this._runOnce = false;
        this.setDaemon(true);
        Trace.trace(TRACE_MASKT, "<> WorkThread(" + name + ")");
    }

    private void startWorkerOnce() {
        this._runOnce = true;
        this.startWorker();
    }

    public synchronized void startWorker() {
        this.start();
    }

    public synchronized void stopWorker() {
        this._stopThread = null;
        this.notify();
    }

    public synchronized void suspendWorker() {
        if (!this._threadSuspended) {
            this._threadSuspended = true;
            this.notify();
        }
    }

    public synchronized void resumeWorker() {
        if (this._threadSuspended) {
            this._threadSuspended = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWork(WorkListener listener, WorkPerformer performer, String requestId, Object params) {
        WorkRequest request = new WorkRequest(listener, performer, requestId, params);
        boolean bNotify = false;
        Object object = this.requestQueueLock;
        synchronized (object) {
            if (this.requestQueue.isEmpty()) {
                bNotify = true;
            }
            this.requestQueue.addLast(request);
        }
        if (bNotify) {
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
    }
}

